//=============================================================================
// DamageFontRedefinition.js
// ----------------------------------------------------------------------------
// (C)2023 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/04/08 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc ダメージフォント変更
 * @target MZ
 * @author くろあめ
 *
 * @param DanageFont
 * @text ダメージポップアップ用フォント
 * @desc ダメージポップアップ用のフォントファイル名を指定します（拡張仕込み）
 * @default mplus-2p-bold-sub.woff
 * @type text
 *
 * @help
 * 標準では、設定の数字フォントを使って表示されるダメージポップアップを
 * それ専用のポップアップを使って表示します。
 *
 * ダメージポップアップフォントとして使用するフォントファイルは
 * プロジェクト直下の「font」フォルダに入れてください。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
*/

(function() {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

// ロードフォント増設＆ダメージスプライトのみフォント変更
const _Scene_Boot_loadGameFonts_og = Scene_Boot.prototype.loadGameFonts;
Scene_Boot.prototype.loadGameFonts = function() {
    const advanced = $dataSystem.advanced;
    FontManager.load("rmmz-mainfont", advanced.mainFontFilename);
    FontManager.load("rmmz-numberfont", advanced.numberFontFilename);
    FontManager.load("rmmz-damagefont", param["DanageFont"]);
};

// 新規定義
Game_System.prototype.damageFontFace = function() {
    return "rmmz-damagefont, " + this.mainFontFace();
};

const _Sprite_Damage_loadGameFonts_og = Scene_Boot.prototype.loadGameFonts;
Sprite_Damage.prototype.fontFace = function() {
    return $gameSystem.damageFontFace();
};
    
})();